const { evaluateRankAndReward } = require("../controllers/rankController");
const User = require("../models/users");
const updateGV = require("./updateGV");

async function propagateDepositAndEvaluateRanks(userId, amount, session) {
  // 1️⃣ Depositing user
  let currentUser = await User.findById(userId).session(session);
  if (!currentUser) return;

  // Personal deposit
  currentUser.rankStats.personalDeposit += amount;
  updateGV(currentUser);
  await currentUser.save({ session });

  // Rank check for depositor
  await evaluateRankAndReward(currentUser, session);

  // 2️⃣ Traverse uplines
  let currentReferralId = currentUser.referredBy;
  let level = 1;

  while (currentReferralId && level <= 6) {
    const upline = await User.findOne({
      referralId: currentReferralId
    }).session(session);

    if (!upline) break;

    if (level === 1) {
      // Direct sponsor
      upline.rankStats.directReferralDeposit += amount;
    } else {
      // Indirect sponsors (levels 2–6)
      upline.rankStats.indirectReferralDeposit += amount;
    }

    updateGV(upline);
    await upline.save({ session });

    await evaluateRankAndReward(upline, session);

    // Move up the tree
    currentReferralId = upline.referredBy;
    level++;
  }
}


module.exports = propagateDepositAndEvaluateRanks;