const nodemailer = require('nodemailer');
const crypto = require('crypto');

const createTransporter = () => {
  return nodemailer.createTransport({
    host: 'server239.web-hosting.com',
    port: 465,
    secure: true,
    auth: {
      user: 'support@Bynax.io',
      pass: 'Abragrps2025.',
    },
  });
};

const generateInvoiceNumber = () => {
  return crypto.randomBytes(8).toString('hex').toUpperCase();
};

const sendWelcomeEmail = async (newUser) => {
  try {
    const transporter = createTransporter();

    const mailOptions = {
      from: 'contact@Bynax.io',
      to: newUser.email,
      subject: 'Welcome to Bynax',
      html: `<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">
  <div style="background-color: #f4f4f4; padding: 20px; border-radius: 10px;">
    <h1 style="color: #D32F2F; text-align: center;">Welcome to Bynax!</h1>
    
    <p style="font-size: 16px; color: #333;">Dear ${newUser.firstName} ${newUser.lastName},</p>
    
    <p style="font-size: 16px; color: #333;">
      Welcome to <strong>Bynax</strong>, a next-generation hedge fund and private investment platform where innovation meets disciplined financial management. We’re excited to have you on board as you take bold steps toward lasting financial success.
    </p>

    <p style="font-size: 16px; color: #333;">
      At Bynax, we don’t just offer investment plans—we craft tailored financial blueprints for individuals, families, and institutions striving for long-term financial independence.
    </p>

    <p style="font-size: 16px; color: #333;">
      Here’s what we offer:
    </p>

    <ul style="font-size: 16px; color: #333; padding-left: 20px;">
      <li><strong>Structured Investment Plans</strong> with weekly and monthly return options</li>
      <li><strong>Investor Loans</strong> available after identity and eligibility verification</li>
      <li><strong>Retirement Planning Services</strong> to grow and protect your future income</li>
      <li><strong>Capital Protection Protocols</strong> for risk-managed wealth expansion</li>
      <li><strong>Global Access</strong> to our secure, digital-first financial services</li>
    </ul>

    <p style="font-size: 16px; color: #333;">
      Our commitment is to guide you with clarity, transparency, and expert insight—every step of the way. Whether you're planning for retirement, seeking sustainable high-yield investments, or exploring loan-backed strategies, our team is here to support your journey.
    </p>

    <p style="font-size: 16px; color: #333;">
      Should you have any questions or need assistance, feel free to reach out to your relationship manager or a member of our support team. We're always here to help.
    </p>

    <p style="font-size: 16px; color: #333;">
      Here’s to your financial growth!
    </p>

    <p style="font-size: 16px; color: #333;">
      Best regards,<br />
      <strong>The Bynax Team</strong>
    </p>
  </div>
</div>`,
    };

    await transporter.sendMail(mailOptions);
    console.log('Welcome email sent to:', newUser.email);
  } catch (err) {
    console.error('Error sending welcome email:', err);
  }
};


const forgotPasswordMail = async (user) => {
  try {
    const transporter = createTransporter();

    const mailOptions = {
      from: 'support@Bynax.io',
      to: user.email,
      subject: 'Password Reset OTP',
      html: `<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; background-color: #f9f9f9; padding: 20px; border-radius: 10px;">
  <h2 style="color: #D32F2F;">Password Reset Request</h2>

  <p style="font-size: 16px; color: #333;">Hi ${user.firstName},</p>

  <p style="font-size: 16px; color: #333;">
    We received a request to reset your password. Please use the one-time password (OTP) below to proceed:
  </p>

  <h3 style="color: #000; font-size: 24px; letter-spacing: 2px;">${user.otp}</h3>

  <p style="font-size: 16px; color: #333;">
    This OTP is valid for the next <strong>15 minutes</strong>. If you did not initiate this request, you can safely ignore this email your account remains secure.
  </p>

  <p style="font-size: 16px; color: #333;">
    Thank you,<br />
    <strong>The Bynax Team</strong>
  </p>
</div>`,
    };

    await transporter.sendMail(mailOptions);
    console.log('Password reset OTP email sent to:', user.email);
  } catch (err) {
    console.error('Error sending password reset email:', err);
  }
};


const sendPaymentInvoice = async (user, newDeposit) => {
  try {
    const transporter = createTransporter();
    const invoiceNumber = generateInvoiceNumber(); // Generate a random invoice number

    const mailOptions = {
      from: 'support@Bynax.io', // Updated email
      to: user.email,
      subject: 'Bynax',
      html: `<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; border: 1px solid #ddd; border-radius: 10px; background-color: #f4f4f4; padding: 20px;">
  <h1 style="color: #D32F2F; text-align: center;">Bynax</h1>

  <div style="background-color: #fff; padding: 20px; border-radius: 10px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);">
    <h2 style="color: #333; text-align: center;">Payment Invoice</h2>

    <p style="font-size: 16px; color: #333;">Dear ${user.firstName} ${user.lastName},</p>

    <p style="font-size: 16px; color: #333;">
      Thank you for choosing Bynax as your trusted investment partner. Below are the details of your recent transaction:
    </p>

    <p style="font-size: 16px; color: #333;"><strong>Invoice Number:</strong> ${invoiceNumber}</p>

    <ul style="font-size: 16px; color: #333; padding-left: 20px;">
      <li><strong>Investment Plan:</strong> ${newDeposit.investmentPlan}</li>
      <li><strong>Amount:</strong> $${newDeposit.amount}</li>
      <li><strong>Payment Method:</strong> ${newDeposit.paymentMethod}</li>
    </ul>

    <p style="font-size: 16px; color: #333;">
      Your investment helps build a personalized financial blueprint that aligns with your goals. Should you have any questions or need further assistance, our support team is here to help.
    </p>

    <p style="font-size: 16px; color: #333;">
      We appreciate your trust in Bynax and look forward to supporting your financial journey.
    </p>

    <p style="font-size: 16px; color: #333;">
      Best regards,<br />
      <strong>The Bynax Team</strong>
    </p>
  </div>
</div>
`,
    };

    await transporter.sendMail(mailOptions);
    console.log('Payment invoice email sent to:', user.email);
  } catch (err) {
    console.error('Error sending payment invoice email:', err);
  }
};




module.exports = { forgotPasswordMail, sendWelcomeEmail, sendPaymentInvoice };
