const User = require("../models/users");

async function getDownlinesByLevel(referralId, maxLevels = 16) {
  const result = {};
  let currentLevelUsers = [referralId]; // level 0 sponsor

  for (let level = 0; level <= maxLevels; level++) {
    const nextUsers = await User.find({
      referredBy: { $in: currentLevelUsers }
    }).select("_id firstName lastName email referralId referredBy rank createdAt");

    if (nextUsers.length === 0) break;

    result[level] = nextUsers;

    // Prepare next iteration
    currentLevelUsers = nextUsers.map(u => u.referralId);
  }

  return result; // e.g., {0: [...], 1:[...], ...}
}

module.exports = getDownlinesByLevel;
