const express = require("express");
const { updateUserROIs, decrementInvestmentTenureDaily } = require("../scheduler");

const router = express.Router();

router.post("/roi/update-weekly", async (req, res) => {
  const startTime = Date.now();
  try {
    await updateUserROIs();
    const endTime = Date.now();
    console.log(`updateUserROIs executed in ${endTime - startTime} ms`);
    res.status(200).json({ message: "User ROI updated successfully" });
  } catch (error) {
    const endTime = Date.now();
    console.error(`Error in updating ROI after ${endTime - startTime} ms:`, error);
    res.status(500).json({ message: "Error updating ROI" });
  }
});

router.post("/roi/decrement-daily", async (req, res) => {
    const startTime = Date.now();
    try {
      await decrementInvestmentTenureDaily();
      const endTime = Date.now();
      console.log(`decrementInvestmentTenureDaily executed in ${endTime - startTime} ms`);
      res.status(200).json({ message: "Investment tenure decremented successfully" });
    } catch (error) {
      const endTime = Date.now();
      console.error(`Error in decrementing tenure after ${endTime - startTime} ms:`, error);
      res.status(500).json({ message: "Error decrementing investment tenure" });
    }
  });

module.exports = router;