const mongoose = require('mongoose');
const { Schema } = mongoose;

// Define the Withdrawal schema
const withdrawalSchema = new Schema({
  withdrawalWallet: {
    type: String,
    required: true,
  },
  amount: {
    type: Number,
    required: true,
  },
  paymentMethod: {
    type: String,
    required: true,
  },
  paymentAddress: {
    type: String,
    required: true,
  },
  status: {
    type: String,
    default: "pending",
  },
  userId: {
    type: mongoose.Schema.Types.ObjectId, // Use ObjectId for references
    required: true,
    ref: 'User', // Reference to the User model
  },
}, { timestamps: true }); // Adds createdAt and updatedAt fields

// Create the Withdrawal model
const Withdrawal = mongoose.model('Withdrawal', withdrawalSchema);

module.exports = Withdrawal;
