const mongoose = require('mongoose');
const { Schema } = mongoose;

// Define the Wallet schema
const walletSchema = new Schema({
  accountName: {
    type: String,
    required: true,
  },
  walletAddress: {
    type: String,
    required: true,
  },
}, { timestamps: true }); // Adds createdAt and updatedAt fields

// Create the Wallet model
const Wallet = mongoose.model('Wallet', walletSchema);

module.exports = Wallet;
