const mongoose = require('mongoose');
const { Schema } = mongoose;

// Generate referral ID
const generateReferralId = () => {
  const chars = 'ABCDEFGHJKLMNPQRSTUVWXYZabcdefghjklmnpqrstuvwxyz23456789';
  let id = 'ID';
  for (let i = 0; i < 6; i++) {
    id += chars[Math.floor(Math.random() * chars.length)];
  }
  return id;
};

const userSchema = new Schema({
  // Basic Profile
  firstName: { type: String, required: true },
  lastName: { type: String, required: true },
  email: { type: String, required: true, unique: true, lowercase: true, trim: true },
  phone: { type: String, required: true },
  country: { type: String, required: true },

  // Auth
  otp: { type: String, required: true },
  password: { type: String, required: true },
  transactionPin: { type: Number, required: true },

  // System
  admin: { type: Boolean, default: false },
  firstDeposit: { type: Boolean, default: false },

  // Referrals
  referralId: {
    type: String,
    default: generateReferralId,
    unique: true,
    index: true,
  },

  referredBy: {
    type: String, // stores referralId of sponsor
    default: null,
    index: true,
  },

  // Fast Stats (DO NOT store arrays)
  directReferralCount: { type: Number, default: 0 },
  teamSize: { type: Number, default: 0 },
  maxDepth: { type: Number, default: 0 },

  // MLM Rank
  rank: { type: String, default: "STARTER", index: true },

  // Wallet Addresses
  btcWallet: { type: String, default: "" },
  ethWallet: { type: String, default: "" },
  usdtWallet: { type: String, default: "" },

  avatar: {
    type: String,
    default:
      "https://static.vecteezy.com/system/resources/previews/005/950/866/original/male-avatar-with-coins-investor-icon-vector.jpg",
  },

  rankStats: {
    personalDeposit: { type: Number, default: 0 },
    directReferralDeposit: { type: Number, default: 0 },
    indirectReferralDeposit: { type: Number, default: 0 },
    groupVolume: { type: Number, default: 0 }
  },
  rankRewards: {
    type: [String], // ["Starter", "Amature"]
    default: []
  }



}, { timestamps: true });

module.exports = mongoose.model("User", userSchema);
