const mongoose = require("mongoose");
const { Schema } = mongoose;

const botSubscriptionSchema = new Schema(
  {
    userId: {
      type: Schema.Types.ObjectId,
      ref: "User",
      index: true,
      required: true,
    },

    botPlanId: {
      type: Schema.Types.ObjectId,
      ref: "BotPlan",
      required: true,
    },

    // Capital assigned to the bot
    amount: {
      type: Number,
      required: true,
      min: 0,
    },

    // 🔥 Snapshot from plan (DO NOT CHANGE AFTER CREATION)
    dailyRoiPercent: {
      type: Number,
      required: true,
      min: 0,
    },

    // Free test days remaining
    freeDaysRemaining: {
      type: Number,
      default: 0,
      min: 0,
    },

    activationFeePaid: {
      type: Boolean,
      default: false,
    },

    status: {
      type: String,
      enum: ["ACTIVE", "COMPLETED", "CANCELLED"],
      default: "ACTIVE",
      index: true,
    },

    startedAt: {
      type: Date,
      default: Date.now,
    },

    endsAt: {
      type: Date,
      default: null,
    },

    lastPayoutAt: {
      type: Date,
      default: null,
    },

    totalProfit: {
      type: Number,
      default: 0,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("BotSubscription", botSubscriptionSchema);
