const mongoose = require("mongoose");

const depositSchema = new mongoose.Schema({
  amount: Number,
  paymentMethod: String,
  userId: { type: mongoose.Schema.Types.ObjectId, ref: 'User' }, // Reference to User
});

const withdrawalSchema = new mongoose.Schema({
  amount: Number,
  paymentMethod: String,
  userId: { type: mongoose.Schema.Types.ObjectId, ref: 'User' }, // Reference to User
});

const userSchema = new mongoose.Schema({
  name: String,
  ROI: Number,
  pendingWithdrawal: Number,
  totalWithdrawal: Number,
  // Other fields...
});

const User = mongoose.model("User", userSchema);
const Deposit = mongoose.model("Deposit", depositSchema);
const Withdrawal = mongoose.model("Withdrawal", withdrawalSchema);

module.exports = { User, Deposit, Withdrawal };
